# Renuma Real Estate - Premium Property Management System

![Renuma Real Estate](https://renumarealestate.com/wp-content/uploads/2024/11/Renuma-real-estate-01.png)

## 🏠 Project Overview

A luxury real estate website with comprehensive property management system, inspired by dpremiumhomes.com design principles and fully branded for Renuma Real Estate.

**Live Reference**: https://renumarealestate.com/

## ✨ Features

### Public Website
- 🎨 Luxury premium design (White + Dark Gray + Gold accents)
- 📱 Fully responsive (Mobile, Tablet, Desktop)
- 🔍 Advanced property search & filters
- 🗺️ Google Maps integration
- 💬 WhatsApp instant chat
- ❤️ Save favorite properties
- 📧 Lead capture forms
- 📱 Click-to-call functionality

### Admin Panel
- 👥 Role-based access (Admin, Agent, Editor)
- 📊 Comprehensive dashboard with analytics
- 🏘️ Property management (CRUD operations)
- 👔 Agent management
- 📬 Lead & inquiry management
- 📝 CMS for all content
- ⚙️ Complete site settings
- 📈 Export functionality (CSV)
- 📧 Email notification system

## 🛠️ Technology Stack

### Backend
- **Framework**: Laravel 10.x
- **Database**: MySQL 8.0
- **Authentication**: Laravel Sanctum
- **File Storage**: Laravel Storage
- **Email**: Laravel Mail with SMTP

### Frontend
- **Framework**: React 18 with Next.js 14
- **Styling**: Tailwind CSS + Custom SCSS
- **State Management**: Redux Toolkit
- **API Client**: Axios
- **Maps**: Google Maps API
- **Forms**: React Hook Form + Yup validation
- **Rich Text**: TinyMCE / Quill
- **Image Gallery**: React Image Gallery
- **Animations**: Framer Motion

### Development Tools
- **API Documentation**: Swagger/OpenAPI
- **Code Quality**: ESLint, Prettier, PHP CS Fixer
- **Version Control**: Git
- **Package Manager**: Composer (PHP), npm (JavaScript)

## 📁 Project Structure

```
renuma-real-estate/
├── backend/                    # Laravel API
│   ├── app/
│   │   ├── Http/
│   │   │   ├── Controllers/
│   │   │   │   ├── API/
│   │   │   │   └── Admin/
│   │   │   ├── Middleware/
│   │   │   └── Requests/
│   │   ├── Models/
│   │   ├── Services/
│   │   └── Repositories/
│   ├── database/
│   │   ├── migrations/
│   │   ├── seeders/
│   │   └── factories/
│   ├── routes/
│   │   ├── api.php
│   │   └── web.php
│   └── config/
│
├── frontend/                   # Next.js Application
│   ├── components/
│   │   ├── common/
│   │   ├── layout/
│   │   ├── home/
│   │   ├── properties/
│   │   └── forms/
│   ├── pages/
│   │   ├── index.js           # Home
│   │   ├── properties/
│   │   ├── about/
│   │   ├── contact/
│   │   └── agents/
│   ├── public/
│   ├── styles/
│   ├── utils/
│   └── store/
│
├── admin-panel/                # React Admin Dashboard
│   ├── src/
│   │   ├── components/
│   │   ├── pages/
│   │   │   ├── Dashboard/
│   │   │   ├── Properties/
│   │   │   ├── Agents/
│   │   │   ├── Leads/
│   │   │   ├── Blog/
│   │   │   └── Settings/
│   │   ├── layouts/
│   │   ├── services/
│   │   └── utils/
│   └── public/
│
└── documentation/
    ├── API.md
    ├── DATABASE_SCHEMA.md
    ├── DEPLOYMENT.md
    └── USER_GUIDE.md
```

## 🗄️ Database Schema

### Core Tables
- `users` - System users (admin, agents)
- `properties` - Property listings
- `property_images` - Property image gallery
- `property_features` - Property amenities
- `property_types` - Types (Apartment, Villa, etc.)
- `locations` - Cities, areas, neighborhoods
- `agents` - Real estate agents
- `leads` - Customer inquiries
- `blog_posts` - Blog articles
- `testimonials` - Customer reviews
- `settings` - Site configuration
- `pages` - CMS pages

## 🚀 Installation

### Prerequisites
- PHP 8.1 or higher
- Node.js 18 or higher
- MySQL 8.0
- Composer
- Git

### Backend Setup

```bash
# Clone repository
cd backend

# Install dependencies
composer install

# Environment setup
cp .env.example .env
php artisan key:generate

# Database setup
php artisan migrate
php artisan db:seed

# Storage link
php artisan storage:link

# Start server
php artisan serve
```

### Frontend Setup

```bash
cd frontend

# Install dependencies
npm install

# Environment setup
cp .env.example .env.local

# Start development server
npm run dev
```

### Admin Panel Setup

```bash
cd admin-panel

# Install dependencies
npm install

# Environment setup
cp .env.example .env.local

# Start development server
npm run dev
```

## 🔐 Default Credentials

### Admin
- Email: admin@renumarealestate.com
- Password: Admin@123

### Agent (Demo)
- Email: agent@renumarealestate.com
- Password: Agent@123

## 📋 API Endpoints

### Public API
```
GET    /api/properties              # List properties
GET    /api/properties/{id}         # Property details
GET    /api/properties/featured     # Featured properties
POST   /api/leads                   # Submit inquiry
GET    /api/agents                  # List agents
GET    /api/blog                    # Blog posts
GET    /api/locations               # Locations
```

### Admin API (Authenticated)
```
POST   /api/admin/login             # Admin login
GET    /api/admin/dashboard         # Dashboard stats
CRUD   /api/admin/properties        # Property management
CRUD   /api/admin/agents            # Agent management
CRUD   /api/admin/leads             # Lead management
CRUD   /api/admin/blog              # Blog management
CRUD   /api/admin/settings          # Settings management
```

## 🎨 Design System

### Color Palette
- **Primary**: #1A1A1A (Dark Gray)
- **Secondary**: #D4AF37 (Gold)
- **Accent**: #4A90E2 (Soft Blue)
- **Background**: #FFFFFF (White)
- **Text**: #333333 (Dark Gray)
- **Light Gray**: #F5F5F5

### Typography
- **Headings**: Playfair Display / Merriweather
- **Body**: Inter / Open Sans
- **Accent**: Montserrat

## 📱 Pages

### Public Pages
1. **Home** - Hero, Search, Featured, Projects, Services, Agents, Testimonials, Blog
2. **About Us** - Company info, team, mission, values
3. **Properties** - All listings with filters
4. **Property Details** - Full details, gallery, map, inquiry form
5. **Buy** - Properties for sale
6. **Sell** - Seller information
7. **Rent** - Rental properties
8. **Projects** - New developments
9. **Agents** - Team members
10. **Blog** - News & articles
11. **Contact** - Contact form, map, info
12. **Login/Register** - User authentication

### Admin Pages
1. **Dashboard** - Stats, charts, recent activity
2. **Properties** - List, add, edit, delete
3. **Agents** - Manage team members
4. **Leads** - View and manage inquiries
5. **Blog** - Content management
6. **Settings** - Site configuration
7. **Users** - User management
8. **Reports** - Analytics & exports

## 🔧 Configuration

### Environment Variables

```env
# Backend (.env)
APP_NAME="Renuma Real Estate"
APP_URL=https://renumarealestate.com

DB_DATABASE=renuma_db
DB_USERNAME=root
DB_PASSWORD=

MAIL_MAILER=smtp
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=renumarealestate@gmail.com
MAIL_PASSWORD=

GOOGLE_MAPS_API_KEY=your_api_key
WHATSAPP_NUMBER=+8801315333100
```

```env
# Frontend (.env.local)
NEXT_PUBLIC_API_URL=http://localhost:8000/api
NEXT_PUBLIC_SITE_URL=https://renumarealestate.com
NEXT_PUBLIC_GOOGLE_MAPS_KEY=your_api_key
NEXT_PUBLIC_WHATSAPP=+8801315333100
```

## 🧪 Testing

```bash
# Backend tests
cd backend
php artisan test

# Frontend tests
cd frontend
npm run test

# E2E tests
npm run test:e2e
```

## 📦 Deployment

### Production Build

```bash
# Backend
composer install --optimize-autoloader --no-dev
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Frontend
npm run build
npm run start

# Admin Panel
npm run build
```

### Deployment Checklist
- [ ] Update .env with production values
- [ ] Set up SSL certificate
- [ ] Configure proper file permissions
- [ ] Set up automated backups
- [ ] Configure email service
- [ ] Set up Google Maps API
- [ ] Configure CDN for images
- [ ] Enable caching
- [ ] Set up monitoring

## 📧 Contact Information

**Renuma Real Estate**
- Email: renumarealestate@gmail.com
- Phone: +8801315333100
- WhatsApp: +8801315333100
- Address: H, Road- 6, Section- 2, Mirpur, Dhaka- 1216, Bangladesh
- Facebook: https://www.facebook.com/renumarealestate
- Instagram: https://www.instagram.com/renumarealestate

## 📄 License

Proprietary - Renuma Real Estate © 2025

## 🤝 Support

For technical support or feature requests, contact the development team.

---

**Built with ❤️ for Renuma Real Estate - "Home of Dreams"**
